/*
 * AltaPendents.java
 *
 * Created on 2 de junio de 2008, 17:12
 */

package actions;

import entitats.Propietari;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class AltaPendents extends Action {
    
    /* forward name="success" path="" */
    private final static String SUCCESS = "ok";
    
    
    DataSource ds = null;
    Connection con = null;
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        Local local = (Local) form;
        String tipus;
        
        try {
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            
            //Elimina el local de la bd per evitar problemes per si l'inspector canvia el local de tipus
            st.executeUpdate("DELETE FROM locals WHERE id_local = " + local.getIdLocal());
            
            
            //Introdueix l'adrea i la zona del local a la taula adreses
            st.executeUpdate("INSERT INTO adreses (id_zona, adresa) VALUES ("+local.getZona()+", '"+local.getAdresa()+"')");
            ResultSet rs1 = st.executeQuery("SELECT last_insert_id()");
            rs1.next();
            int idAdresa = rs1.getInt(1);
            
            //Introdueix el nou local, crea un codi_local temporal que mes tard sera substituit
            PreparedStatement sentencia = con.prepareStatement("INSERT INTO locals(codi_local, id_adresa, tipus, superficie, caracteristiques, restriccions, preu, actiu) VALUES(?,?,?,?,?,?,?,?)");
            sentencia.setString(1, "temporal");
            sentencia.setInt(2,idAdresa);
            sentencia.setString(3, local.getTipus());
            sentencia.setFloat(4, local.getSuperficie());
            sentencia.setString(5, local.getCaracteristiques());
            sentencia.setString(6, local.getRestriccions());
            sentencia.setFloat(7, local.getPreu());
            sentencia.setBoolean(8, true);
            sentencia.executeUpdate();
            
            
            rs1 = st.executeQuery("SELECT last_insert_id()");
            rs1.next();
            int idLocal = rs1.getInt(1);
            String codiLocal = local.creaCodi(idLocal);
            st.executeUpdate("UPDATE locals SET codi_local = '"+codiLocal+"', id_local = "+local.getIdLocal()+" WHERE id_local = "+idLocal);
            
            if (local.getTipus().equals("oficina")){
                st.executeUpdate("INSERT INTO oficines(id_local) VALUES("+idLocal+")");
            } else if (local.getTipus().equals("botiga_magatzem")){
                st.executeUpdate("INSERT INTO botigues_magatzem(id_local, volum) VALUES("+idLocal+", "+local.getVolum()+")");
            } else if (local.getTipus().equals("polivalent")){
                st.executeUpdate("INSERT INTO polivalents(id_local, caracteristiques_polivalent) VALUES("+idLocal+", '"+local.getCaracteristiquesPolivalents()+"')");
            } else if (local.getTipus().equals("immoble")){
                st.executeUpdate("INSERT INTO immobles(id_local) VALUES("+idLocal+")");
            }
            local.setError("Local afegit correctament");
        } catch(Exception excepcio){
            local.setError("<font color='red'>Excepcio ocorreguda en acions.AltaLocal" +
                    "\n"+excepcio.getMessage()+"<font>");
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                local.setError("<font color='red'>Excepcio ocorreguda en acions.AltaLocal" +
                        "\n"+excepcio.getMessage()+"<font>");
                return mapping.findForward("ok");
            }
        }
        
        return mapping.findForward("ok");
    }
}